/*******************************************************************************/
/*  
	This script cleans the OES data. 
	Download May 2018 OES from https://www.bls.gov/oes/tables.htm
		- National
		- National x Industry

    --
	Alexander Weinberg
	February 16, 2021
*/
/*******************************************************************************/

 
/*----------------------------------------------------*/
			/* [>   NATIONAL OES   <] */ 
/*----------------------------------------------------*/

//________________________________________________________________
// Import national OES
import excel "../Raw Data/OES/national_M2018_dl.xlsx", firstrow clear

rename (OCC_CODE OCC_TITLE TOT_EMP) (oes2019 oestitle tot_emp)
keep if OCC_GROUP == "detailed" 		// Drop Aggregated occupation groups
keep oes* tot_emp 

//________________________________________________________________
// Label Variables
label var oes2019 "6-digit SOC occupation code (OES 2019 version)" 
label var oestitle "Occupation title (SOC-OES codes)"
label var tot_emp "Estimated total employment rounded to the nearest 10 (excludes self-employed)"

//________________________________________________________________
// Cleanup
collapse (rawsum) tot_emp (first) oestitle, fast by(oes2019)

keep  oes2019 tot_emp
order oes2019 tot_emp
sort  oes2019 
duplicates report oes2019

save "../Data/OES/oes_nat_clean", replace


/*----------------------------------------------------*/
			/* [>   INDUSTRY OES   <] */ 
/*----------------------------------------------------*/

//________________________________________________________________
// Import Industry OES
import excel "../Raw Data/OES/nat4d_M2018_dl.xlsx", firstrow clear

rename (OCC_CODE OCC_TITLE TOT_EMP NAICS) (oes2019 oestitle tot_emp naics)
keep if OCC_GROUP == "detailed" 						// Drop Aggregated occupation groups
keep oes* tot_emp naics

//________________________________________________________________
// Employment 
replace tot_emp = "." if tot_emp=="**"
destring tot_emp, replace

//________________________________________________________________
// Label Variables
label var oes2019 "6-digit SOC occupation code (OES 2019 version)" 
label var oestitle "Occupation title (SOC-OES codes)"
label var tot_emp "Estimated total employment rounded to the nearest 10 (excludes self-employed)"
label var naics "4 digit NAICS code"
 
//________________________________________________________________
// Cleanup
keep  oes2019 tot_emp naics*
order naics oes2019 tot_emp
sort  oes2019 naics 
duplicates report oes2019 naics

compress
save "../Data/OES/oes_ind_clean", replace
// end
